package jamezo97.clonecraft.gui;


import jamezo97.clonecraft.block.TileEntityCentrifuge;
import jamezo97.clonecraft.network.Handler1SpinCentrifuge;

import java.io.File;
import java.io.IOException;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiCentrifuge extends GuiContainer{
	TileEntityCentrifuge te = null;
	int dimension;
	
	ResourceLocation centrifuge = new ResourceLocation("CloneCraft:textures/gui/centrifuge.png");
	
	public GuiCentrifuge(EntityPlayer p, TileEntityCentrifuge teC) {
		super(new ContainerCentrifuge(p.inventory, teC));
		dimension = p.worldObj.provider.dimensionId;
		te = teC;
		
	}
    protected void drawGuiContainerForegroundLayer(int par1, int par2)
    {
        fontRenderer.drawString("Centrifuge", 8, 6, 0x404040);
        fontRenderer.drawString("Inventory", 8, (ySize - 106) + 2, 0x404040);
        if(te.isBurning()){
        	GL11.glPushMatrix();
        	mc.getTextureManager().bindTexture(centrifuge);
        	GL11.glEnable(GL11.GL_BLEND);
        	GL11.glBlendFunc (GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);
            GL11.glColor4f(1.0F, 1.0F, 1.0F, 0.6F);
        	int minus = (int)Math.round(14d*te.getFuelDone());
        	drawTexturedModalRect(81, 30+(14-minus), 177, 1+(14-minus), 14, minus);
        	GL11.glDisable(GL11.GL_BLEND);
        	GL11.glPopMatrix();
        }
    }
    
    
    //Screw this lols
/*    
    protected void handleMouseClick(Slot slot, int i, int j, int k)
    {
    	if (slot != null)
        {
        	int b = slot.slotNumber;
        	if(te.isSpinning() && (b == 0 || b == 1 || b == 2 || b == 3)){
        		return;
        	}
            i = slot.slotNumber;
        }
        this.mc.playerController.windowClick(this.inventorySlots.windowId, i, j, k, this.mc.thePlayer);
    }*/
    
/*    
    int number = 0;
    @Override
	protected void keyTyped(char par1, int par2) {
    	if(par2 == 41){
    		ItemStack stack = mc.thePlayer.inventory.getItemStack();
    		if(stack != null){
    			File file = new File("Output" + number++ + ".dat");
    			System.out.println(file.getAbsolutePath());
    			NBTTagCompound nbt = new NBTTagCompound();
    			try {
					CompressedStreamTools.write(stack.writeToNBT(nbt), file);
					System.out.println("Saved selected Stack");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
    		}else{
    			System.out.println("Stack is null, stuff that.");
    		}
    	}
    	super.keyTyped(par1, par2);
		System.out.println(Keyboard.getEventKeyState() + "|" + par1 + "|" + par2);
	}*/
	@Override
	protected void actionPerformed(GuiButton guibutton) {
		if(guibutton.id == 0){
			if(te.canSpin() && (te.isBurning() || TileEntityFurnace.getItemBurnTime(te.items[4])>0)){
				new Handler1SpinCentrifuge(te.xCoord, te.yCoord, te.zCoord, inventorySlots.windowId).sendToServer();
/*				MyPeople.packetHandler.sendPacketToServer(MyPeoplePacketType.serverCentrifuge.id, new Object[]{
						dimension, te.xCoord, te.yCoord, te.zCoord, inventorySlots.windowId
				});*/
			}
		}
	}
	@Override
	public void updateScreen() {
		spin.enabled = !te.spinPressed;
	}
	GuiButton spin;
	public void initGui() {
		super.initGui();
		buttonList.clear();
		buttonList.add(spin = new GuiButton(0, guiLeft+100, guiTop+6, 72, 20, "Spin"));
		spin.enabled = te.spinPressed;
	}
	protected void drawGuiContainerBackgroundLayer(float f, int i, int j)
    {
		GL11.glPushMatrix();
		mc.getTextureManager().bindTexture(centrifuge);
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
//        GL11.glBindTexture(GL11.GL_TEXTURE_2D, k);
        
        int l = (width - xSize) / 2;
        int i1 = (height - ySize) / 2;
        drawTexturedModalRect(l, i1, 0, 0, xSize, ySize);
        drawTexturedModalRect(8+l, 72+i1, 0, 166, (int)Math.round(160d*te.getPercentDone()), 6);
        GL11.glPopMatrix();
    }

}

